//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.csc.v1_0.model;

import java.lang.String;

/**
 * 机器人回答内容为文本 */
public class RobotText {
  private String answerSource;

  private String content;

  /**
   * 答案来源。TEMPLATE：模板拦截，模板拦截中配置的输出文本；DST_ASK：多轮对话的反问文本，意图管理中配置的属性问句；DST_ANSWER：多轮对话的答案文本，意图管理中配置的输出文本；DST_PASSTHROUGH：多轮对话透传给调用方的数据，该数据不限制格式；ST_CHAT：闲聊；WEATHER：天气；ENCYCLOPEDIAS：百科；INFORMATION: 资讯；STOCK：股票；SORRY：致歉语 */
  public String getAnswerSource() {
    return this.answerSource;
  }

  /**
   * 答案来源。TEMPLATE：模板拦截，模板拦截中配置的输出文本；DST_ASK：多轮对话的反问文本，意图管理中配置的属性问句；DST_ANSWER：多轮对话的答案文本，意图管理中配置的输出文本；DST_PASSTHROUGH：多轮对话透传给调用方的数据，该数据不限制格式；ST_CHAT：闲聊；WEATHER：天气；ENCYCLOPEDIAS：百科；INFORMATION: 资讯；STOCK：股票；SORRY：致歉语 */
  public void setAnswerSource(String answerSource) {
    this.answerSource = answerSource;
  }

  /**
   * 文本答案的内容 */
  public String getContent() {
    return this.content;
  }

  /**
   * 文本答案的内容 */
  public void setContent(String content) {
    this.content = content;
  }
}
