//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.csc.v1_0.model;

import java.lang.String;
import java.util.List;

/**
 * 会话的问答详情模型 */
public class RobotSessionDetail {
  private List<RobotMessage> messages;

  private String messageId;

  private String sessionId;

  private String utterance;

  /**
   * 机器人回答详情列表 */
  public List<RobotMessage> getMessages() {
    return this.messages;
  }

  /**
   * 机器人回答详情列表 */
  public void setMessages(List<RobotMessage> messages) {
    this.messages = messages;
  }

  /**
   * 本次机器人回答的id，每次机器人回答id不同 */
  public String getMessageId() {
    return this.messageId;
  }

  /**
   * 本次机器人回答的id，每次机器人回答id不同 */
  public void setMessageId(String messageId) {
    this.messageId = messageId;
  }

  /**
   * 机器人会话ID */
  public String getSessionId() {
    return this.sessionId;
  }

  /**
   * 机器人会话ID */
  public void setSessionId(String sessionId) {
    this.sessionId = sessionId;
  }

  /**
   * 提问内容 */
  public String getUtterance() {
    return this.utterance;
  }

  /**
   * 提问内容 */
  public void setUtterance(String utterance) {
    this.utterance = utterance;
  }
}
