//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.csc.v1_0.model;

import java.lang.String;
import java.util.List;

/**
 * 机器人回答详情 */
public class RobotMessage {
  private RobotKnowledge knowledge;

  private List<RobotRecommend> recommends;

  private RobotSelection selection;

  private RobotText text;

  private String type;

  /**
   * 当type=KNOWLEDGE时，值为RobotKnowledge对象 */
  public RobotKnowledge getKnowledge() {
    return this.knowledge;
  }

  /**
   * 当type=KNOWLEDGE时，值为RobotKnowledge对象 */
  public void setKnowledge(RobotKnowledge knowledge) {
    this.knowledge = knowledge;
  }

  /**
   * 当type=RECOMMEND时，值为RobotRecommend对象数组 */
  public List<RobotRecommend> getRecommends() {
    return this.recommends;
  }

  /**
   * 当type=RECOMMEND时，值为RobotRecommend对象数组 */
  public void setRecommends(List<RobotRecommend> recommends) {
    this.recommends = recommends;
  }

  /**
   * 当type=SELECTION时，值为RobotSelection对象 */
  public RobotSelection getSelection() {
    return this.selection;
  }

  /**
   * 当type=SELECTION时，值为RobotSelection对象 */
  public void setSelection(RobotSelection selection) {
    this.selection = selection;
  }

  /**
   * 当type=TEXT时，值为RobotText对象 */
  public RobotText getText() {
    return this.text;
  }

  /**
   * 当type=TEXT时，值为RobotText对象 */
  public void setText(RobotText text) {
    this.text = text;
  }

  /**
   * 消息的类型，TEXT：文本；KNOWLEDGE：知识库关联问题；RECOMMEND：知识库关联问题推荐；SELECTION：选择类型（目前多轮对话中可能会出现） */
  public String getType() {
    return this.type;
  }

  /**
   * 消息的类型，TEXT：文本；KNOWLEDGE：知识库关联问题；RECOMMEND：知识库关联问题推荐；SELECTION：选择类型（目前多轮对话中可能会出现） */
  public void setType(String type) {
    this.type = type;
  }
}
