//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.csc.v1_0.model;

import java.lang.Long;
import java.lang.String;
import javax.validation.constraints.NotNull;

/**
 * 在线坐席监控指标 */
public class OnlineAgentMetric {
  @NotNull
  private String agentId;

  @NotNull
  private String jobNumber;

  @NotNull
  private String metricDetail;

  @NotNull
  private String realName;

  @NotNull
  private Long timestamp;

  /**
   * 坐席id */
  public String getAgentId() {
    return this.agentId;
  }

  /**
   * 坐席id */
  public void setAgentId(String agentId) {
    this.agentId = agentId;
  }

  /**
   * 坐席工号 */
  public String getJobNumber() {
    return this.jobNumber;
  }

  /**
   * 坐席工号 */
  public void setJobNumber(String jobNumber) {
    this.jobNumber = jobNumber;
  }

  /**
   * json格式的监控指标，key为监控指标的名称，value为监控指标的值 */
  public String getMetricDetail() {
    return this.metricDetail;
  }

  /**
   * json格式的监控指标，key为监控指标的名称，value为监控指标的值 */
  public void setMetricDetail(String metricDetail) {
    this.metricDetail = metricDetail;
  }

  /**
   * 姓名 */
  public String getRealName() {
    return this.realName;
  }

  /**
   * 姓名 */
  public void setRealName(String realName) {
    this.realName = realName;
  }

  /**
   * 指标计算时的时间戳，精确到毫秒 */
  public Long getTimestamp() {
    return this.timestamp;
  }

  /**
   * 指标计算时的时间戳，精确到毫秒 */
  public void setTimestamp(Long timestamp) {
    this.timestamp = timestamp;
  }
}
