//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.csc.v1_0.model;

import java.lang.String;
import java.util.Date;
import javax.validation.constraints.NotNull;

/**
 * 公告 */
public class Notice {
  @NotNull
  private String ccsInstanceId;

  @NotNull
  private String content;

  @NotNull
  private Date createTime;

  @NotNull
  private String creatorId;

  @NotNull
  private Date endTime;

  @NotNull
  private Date startTime;

  @NotNull
  private String status;

  @NotNull
  private String type;

  private String updaterId;

  private Date updateTime;

  /**
   * 数据权限id(云客服租户实例id)，如果为空，则为默认数据权限 */
  public String getCcsInstanceId() {
    return this.ccsInstanceId;
  }

  /**
   * 数据权限id(云客服租户实例id)，如果为空，则为默认数据权限 */
  public void setCcsInstanceId(String ccsInstanceId) {
    this.ccsInstanceId = ccsInstanceId;
  }

  /**
   * 公告内容 */
  public String getContent() {
    return this.content;
  }

  /**
   * 公告内容 */
  public void setContent(String content) {
    this.content = content;
  }

  /**
   * 创建时间（发布时间） */
  public Date getCreateTime() {
    return this.createTime;
  }

  /**
   * 创建时间（发布时间） */
  public void setCreateTime(Date createTime) {
    this.createTime = createTime;
  }

  /**
   * 创建人（发布人）ID */
  public String getCreatorId() {
    return this.creatorId;
  }

  /**
   * 创建人（发布人）ID */
  public void setCreatorId(String creatorId) {
    this.creatorId = creatorId;
  }

  /**
   * 公告失效时间 */
  public Date getEndTime() {
    return this.endTime;
  }

  /**
   * 公告失效时间 */
  public void setEndTime(Date endTime) {
    this.endTime = endTime;
  }

  /**
   * 公告生效时间 */
  public Date getStartTime() {
    return this.startTime;
  }

  /**
   * 公告生效时间 */
  public void setStartTime(Date startTime) {
    this.startTime = startTime;
  }

  /**
   * 公告状态。 枚举值： ENABLE：启用 DISABLE：停用 OVERDUE：过期 */
  public String getStatus() {
    return this.status;
  }

  /**
   * 公告状态。 枚举值： ENABLE：启用 DISABLE：停用 OVERDUE：过期 */
  public void setStatus(String status) {
    this.status = status;
  }

  /**
   * 公告类型，能看到公告的人。 枚举值： USER：用户 AGENT：客服 */
  public String getType() {
    return this.type;
  }

  /**
   * 公告类型，能看到公告的人。 枚举值： USER：用户 AGENT：客服 */
  public void setType(String type) {
    this.type = type;
  }

  /**
   * 最后修改人ID */
  public String getUpdaterId() {
    return this.updaterId;
  }

  /**
   * 最后修改人ID */
  public void setUpdaterId(String updaterId) {
    this.updaterId = updaterId;
  }

  /**
   * 最后修改时间 */
  public Date getUpdateTime() {
    return this.updateTime;
  }

  /**
   * 最后修改时间 */
  public void setUpdateTime(Date updateTime) {
    this.updateTime = updateTime;
  }
}
