//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.csc.v1_0.model;

import java.lang.String;
import javax.validation.constraints.NotNull;

/**
 * 租户实例（数据权限）。一个租户下可以有多个租户实例，每个租户实例之间的业务数据是相互隔离的，通过open api只能获取单一租户实例的数据。 */
public class Instance {
  @NotNull
  private String createTime;

  @NotNull
  private String creatorId;

  private String description;

  @NotNull
  private String id;

  @NotNull
  private String name;

  @NotNull
  private String updaterId;

  @NotNull
  private String updateTime;

  /**
   * ​创建时间，按照ISO8601标准表示 */
  public String getCreateTime() {
    return this.createTime;
  }

  /**
   * ​创建时间，按照ISO8601标准表示 */
  public void setCreateTime(String createTime) {
    this.createTime = createTime;
  }

  /**
   * 创建人id */
  public String getCreatorId() {
    return this.creatorId;
  }

  /**
   * 创建人id */
  public void setCreatorId(String creatorId) {
    this.creatorId = creatorId;
  }

  /**
   * 描述 */
  public String getDescription() {
    return this.description;
  }

  /**
   * 描述 */
  public void setDescription(String description) {
    this.description = description;
  }

  /**
   * 租户实例ID */
  public String getId() {
    return this.id;
  }

  /**
   * 租户实例ID */
  public void setId(String id) {
    this.id = id;
  }

  /**
   * 租户实例id（数据权限id） */
  public String getName() {
    return this.name;
  }

  /**
   * 租户实例id（数据权限id） */
  public void setName(String name) {
    this.name = name;
  }

  /**
   * 最后修改人id */
  public String getUpdaterId() {
    return this.updaterId;
  }

  /**
   * 最后修改人id */
  public void setUpdaterId(String updaterId) {
    this.updaterId = updaterId;
  }

  /**
   * 最后修改时间，按照ISO8601标准表示 */
  public String getUpdateTime() {
    return this.updateTime;
  }

  /**
   * 最后修改时间，按照ISO8601标准表示 */
  public void setUpdateTime(String updateTime) {
    this.updateTime = updateTime;
  }
}
