//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.csc.v1_0.model;

import java.lang.String;

/**
 * 角色扮演的身份信息，使用该身份以指定的操作访问指定资源，比如：上传文件到指定bucket和prefix的oss */
public class Credentials {
  private String accessKeyId;

  private String accessKeySecret;

  private String expiration;

  private String securityToken;

  /**
   * 访问密钥标识 */
  public String getAccessKeyId() {
    return this.accessKeyId;
  }

  /**
   * 访问密钥标识 */
  public void setAccessKeyId(String accessKeyId) {
    this.accessKeyId = accessKeyId;
  }

  /**
   * 访问密钥 */
  public String getAccessKeySecret() {
    return this.accessKeySecret;
  }

  /**
   * 访问密钥 */
  public void setAccessKeySecret(String accessKeySecret) {
    this.accessKeySecret = accessKeySecret;
  }

  /**
   * 过期时间，按照ISO8601标准表示 */
  public String getExpiration() {
    return this.expiration;
  }

  /**
   * 过期时间，按照ISO8601标准表示 */
  public void setExpiration(String expiration) {
    this.expiration = expiration;
  }

  /**
   * 安全令牌 */
  public String getSecurityToken() {
    return this.securityToken;
  }

  /**
   * 安全令牌 */
  public void setSecurityToken(String securityToken) {
    this.securityToken = securityToken;
  }
}
