//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.csc.v1_0.model;

import java.lang.String;
import javax.validation.constraints.NotNull;

/**
 * 云客服通用的配置模型 */
public class Configuration {
  @NotNull
  private String name;

  @NotNull
  private String type;

  @NotNull
  private String value;

  /**
   * 配置名称 */
  public String getName() {
    return this.name;
  }

  /**
   * 配置名称 */
  public void setName(String name) {
    this.name = name;
  }

  /**
   * 配置值的数据类型：
   * INTEGER：long类型的数字；
   * STRING：字符串； */
  public String getType() {
    return this.type;
  }

  /**
   * 配置值的数据类型：
   * INTEGER：long类型的数字；
   * STRING：字符串； */
  public void setType(String type) {
    this.type = type;
  }

  /**
   * 配置项的值 */
  public String getValue() {
    return this.value;
  }

  /**
   * 配置项的值 */
  public void setValue(String value) {
    this.value = value;
  }
}
