//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.csc.v1_0.model;

import java.lang.String;
import javax.validation.constraints.NotNull;

/**
 * 外呼活动时间计划 */
public class CampaignSchedule {
  @NotNull
  private String endTime;

  @NotNull
  private String startTime;

  /**
   * 外呼时间段的结束时间, 格式：HH:mm */
  public String getEndTime() {
    return this.endTime;
  }

  /**
   * 外呼时间段的结束时间, 格式：HH:mm */
  public void setEndTime(String endTime) {
    this.endTime = endTime;
  }

  /**
   * 外呼时间段的开始时间, 格式：HH:mm */
  public String getStartTime() {
    return this.startTime;
  }

  /**
   * 外呼时间段的开始时间, 格式：HH:mm */
  public void setStartTime(String startTime) {
    this.startTime = startTime;
  }
}
