//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.csc.v1_0.model;

import java.lang.String;
import java.util.List;
import javax.validation.constraints.NotNull;

/**
 * 客服在线技能组信息 */
public class AgentChatModel {
  @NotNull
  private String ccsInstanceId;

  @NotNull
  private List<String> extendedGroupIds;

  @NotNull
  private String groupId;

  @NotNull
  private String levelId;

  /**
   * 数据权限id(租户实例id)：ZPASFSCN */
  public String getCcsInstanceId() {
    return this.ccsInstanceId;
  }

  /**
   * 数据权限id(租户实例id)：ZPASFSCN */
  public void setCcsInstanceId(String ccsInstanceId) {
    this.ccsInstanceId = ccsInstanceId;
  }

  /**
   * 在线扩展技能组id列表：1、2 */
  public List<String> getExtendedGroupIds() {
    return this.extendedGroupIds;
  }

  /**
   * 在线扩展技能组id列表：1、2 */
  public void setExtendedGroupIds(List<String> extendedGroupIds) {
    this.extendedGroupIds = extendedGroupIds;
  }

  /**
   * 在线技能组id：1 */
  public String getGroupId() {
    return this.groupId;
  }

  /**
   * 在线技能组id：1 */
  public void setGroupId(String groupId) {
    this.groupId = groupId;
  }

  /**
   * 在线服务等级：100000000001 */
  public String getLevelId() {
    return this.levelId;
  }

  /**
   * 在线服务等级：100000000001 */
  public void setLevelId(String levelId) {
    this.levelId = levelId;
  }
}
