//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.blockchain.v1_0_0.response;

import cn.com.antcloud.api.product.provider.AntCloudProdProviderResponse;
import cn.com.antcloud.api.provider.blockchain.v1_0_0.model.DiscreteValue;
import java.lang.String;
import java.util.List;

/**
 * 售卖页面加载产品个性化内容，比如：类目、库存等，用于辅助用户选择。用户下单后参数会下发给产品方 */
public class InitProductResponse extends AntCloudProdProviderResponse<InitProductResponse> {
  private List<DiscreteValue> discreteValues;

  private String reqMsgId;

  private String resultCode;

  private String resultMsg;

  private String sign;

  /**
   * 组合内容 */
  public List<DiscreteValue> getDiscreteValues() {
    return this.discreteValues;
  }

  /**
   * 组合内容 */
  public void setDiscreteValues(List<DiscreteValue> discreteValues) {
    this.discreteValues = discreteValues;
  }

  /**
   * 请求中的req_msg_id */
  public String getReqMsgId() {
    return this.reqMsgId;
  }

  /**
   * 请求中的req_msg_id */
  public void setReqMsgId(String reqMsgId) {
    this.reqMsgId = reqMsgId;
  }

  /**
   * 结果码 */
  public String getResultCode() {
    return this.resultCode;
  }

  /**
   * 结果码 */
  public void setResultCode(String resultCode) {
    this.resultCode = resultCode;
  }

  /**
   * 结果消息 */
  public String getResultMsg() {
    return this.resultMsg;
  }

  /**
   * 结果消息 */
  public void setResultMsg(String resultMsg) {
    this.resultMsg = resultMsg;
  }

  /**
   * 签名结果 */
  public String getSign() {
    return this.sign;
  }

  /**
   * 签名结果 */
  public void setSign(String sign) {
    this.sign = sign;
  }
}
