//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.blockchain.v1_0_0.request;

import cn.com.antcloud.api.product.provider.AntCloudProdProviderRequest;
import cn.com.antcloud.api.provider.blockchain.v1_0_0.response.StartPersonAgentcreateResponse;
import java.lang.String;
import javax.validation.constraints.NotNull;

/**
 * 通过代理模式为个人创建did */
public class StartPersonAgentcreateRequest extends AntCloudProdProviderRequest<StartPersonAgentcreateResponse> {
  @NotNull
  private String createOdel;

  private String extensionInfo;

  private String ownerName;

  @NotNull
  private String ownerUid;

  /**
   * 代理模式 */
  public String getCreateOdel() {
    return this.createOdel;
  }

  /**
   * 代理模式 */
  public void setCreateOdel(String createOdel) {
    this.createOdel = createOdel;
  }

  /**
   * 企业自定信息 */
  public String getExtensionInfo() {
    return this.extensionInfo;
  }

  /**
   * 企业自定信息 */
  public void setExtensionInfo(String extensionInfo) {
    this.extensionInfo = extensionInfo;
  }

  /**
   * 名称 */
  public String getOwnerName() {
    return this.ownerName;
  }

  /**
   * 名称 */
  public void setOwnerName(String ownerName) {
    this.ownerName = ownerName;
  }

  /**
   * hash(证件类型+企业营业执照号) 由调用者，或者浏览器直接生成 */
  public String getOwnerUid() {
    return this.ownerUid;
  }

  /**
   * hash(证件类型+企业营业执照号) 由调用者，或者浏览器直接生成 */
  public void setOwnerUid(String ownerUid) {
    this.ownerUid = ownerUid;
  }
}
