//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.blockchain.v1_0_0.request;

import cn.com.antcloud.api.product.provider.AntCloudProdProviderRequest;
import cn.com.antcloud.api.provider.blockchain.v1_0_0.response.StartCorporateAgentcreateResponse;
import java.lang.String;
import javax.validation.constraints.NotNull;

/**
 * 通过代理模式为企业创建did */
public class StartCorporateAgentcreateRequest extends AntCloudProdProviderRequest<StartCorporateAgentcreateResponse> {
  private String extensionInfo;

  private String ownerName;

  @NotNull
  private String ownerUid;

  /**
   * 扩展字段 */
  public String getExtensionInfo() {
    return this.extensionInfo;
  }

  /**
   * 扩展字段 */
  public void setExtensionInfo(String extensionInfo) {
    this.extensionInfo = extensionInfo;
  }

  /**
   * 企业名称 */
  public String getOwnerName() {
    return this.ownerName;
  }

  /**
   * 企业名称 */
  public void setOwnerName(String ownerName) {
    this.ownerName = ownerName;
  }

  /**
   * 自定义企业唯一id，企业在自有模式下的唯一号bid的hash值，调用者需要保证其唯一性 */
  public String getOwnerUid() {
    return this.ownerUid;
  }

  /**
   * 自定义企业唯一id，企业在自有模式下的唯一号bid的hash值，调用者需要保证其唯一性 */
  public void setOwnerUid(String ownerUid) {
    this.ownerUid = ownerUid;
  }
}
