//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.blockchain.v1_0_0.request;

import cn.com.antcloud.api.product.provider.AntCloudProdProviderRequest;
import cn.com.antcloud.api.provider.blockchain.v1_0_0.response.ListUserbizkeyResponse;
import java.lang.String;
import javax.validation.constraints.NotNull;

/**
 * 列出用户在某条链上所有的密钥 */
public class ListUserbizkeyRequest extends AntCloudProdProviderRequest<ListUserbizkeyResponse> {
  @NotNull
  private String bizid;

  /**
   * 区块链id */
  public String getBizid() {
    return this.bizid;
  }

  /**
   * 区块链id */
  public void setBizid(String bizid) {
    this.bizid = bizid;
  }
}
