//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.blockchain.v1_0_0.request;

import cn.com.antcloud.api.product.provider.AntCloudProdProviderRequest;
import cn.com.antcloud.api.provider.blockchain.v1_0_0.response.GetTransactionResponse;
import java.lang.String;
import javax.validation.constraints.NotNull;

/**
 * ⽤用户通过存证事务Token，获取事务中所有的存证信息 */
public class GetTransactionRequest extends AntCloudProdProviderRequest<GetTransactionResponse> {
  @NotNull
  private String token;

  /**
   * 存证事务ID */
  public String getToken() {
    return this.token;
  }

  /**
   * 存证事务ID */
  public void setToken(String token) {
    this.token = token;
  }
}
