//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.blockchain.v1_0_0.request;

import cn.com.antcloud.api.product.provider.AntCloudProdProviderRequest;
import cn.com.antcloud.api.provider.blockchain.v1_0_0.response.CreateMappingInfoResponse;
import java.lang.Long;
import java.lang.String;
import javax.validation.constraints.NotNull;

/**
 * 用户信息存储 */
public class CreateMappingInfoRequest extends AntCloudProdProviderRequest<CreateMappingInfoResponse> {
  private String address;

  @NotNull
  private String bizCode;

  @NotNull
  private String bizName;

  private String bizType;

  private String createTime;

  private String endTime;

  private String extension;

  @NotNull
  private String groupCode;

  @NotNull
  private String groupName;

  private Long identityType;

  private String identityValue;

  private String label;

  private String statDate;

  private String userId;

  private String userName;

  private String userType;

  /**
   * 注册地址 */
  public String getAddress() {
    return this.address;
  }

  /**
   * 注册地址 */
  public void setAddress(String address) {
    this.address = address;
  }

  /**
   * 业务场景code */
  public String getBizCode() {
    return this.bizCode;
  }

  /**
   * 业务场景code */
  public void setBizCode(String bizCode) {
    this.bizCode = bizCode;
  }

  /**
   * 业务名称 */
  public String getBizName() {
    return this.bizName;
  }

  /**
   * 业务名称 */
  public void setBizName(String bizName) {
    this.bizName = bizName;
  }

  /**
   * 业务类型，预留 */
  public String getBizType() {
    return this.bizType;
  }

  /**
   * 业务类型，预留 */
  public void setBizType(String bizType) {
    this.bizType = bizType;
  }

  /**
   * 用户创建时间 */
  public String getCreateTime() {
    return this.createTime;
  }

  /**
   * 用户创建时间 */
  public void setCreateTime(String createTime) {
    this.createTime = createTime;
  }

  /**
   * 用户注销时间 */
  public String getEndTime() {
    return this.endTime;
  }

  /**
   * 用户注销时间 */
  public void setEndTime(String endTime) {
    this.endTime = endTime;
  }

  /**
   * 扩展字段，使用json格式 */
  public String getExtension() {
    return this.extension;
  }

  /**
   * 扩展字段，使用json格式 */
  public void setExtension(String extension) {
    this.extension = extension;
  }

  /**
   * 业务组code */
  public String getGroupCode() {
    return this.groupCode;
  }

  /**
   * 业务组code */
  public void setGroupCode(String groupCode) {
    this.groupCode = groupCode;
  }

  /**
   * 业务组名称 */
  public String getGroupName() {
    return this.groupName;
  }

  /**
   * 业务组名称 */
  public void setGroupName(String groupName) {
    this.groupName = groupName;
  }

  /**
   * 唯一标示类型，0:统一信用代码,1:开票机构代码,2:身份证号 */
  public Long getIdentityType() {
    return this.identityType;
  }

  /**
   * 唯一标示类型，0:统一信用代码,1:开票机构代码,2:身份证号 */
  public void setIdentityType(Long identityType) {
    this.identityType = identityType;
  }

  /**
   * 唯一标示码 */
  public String getIdentityValue() {
    return this.identityValue;
  }

  /**
   * 唯一标示码 */
  public void setIdentityValue(String identityValue) {
    this.identityValue = identityValue;
  }

  /**
   * 用户标签 */
  public String getLabel() {
    return this.label;
  }

  /**
   * 用户标签 */
  public void setLabel(String label) {
    this.label = label;
  }

  /**
   * 统计时间 */
  public String getStatDate() {
    return this.statDate;
  }

  /**
   * 统计时间 */
  public void setStatDate(String statDate) {
    this.statDate = statDate;
  }

  /**
   * 用户id */
  public String getUserId() {
    return this.userId;
  }

  /**
   * 用户id */
  public void setUserId(String userId) {
    this.userId = userId;
  }

  /**
   * 用户或企业名称 */
  public String getUserName() {
    return this.userName;
  }

  /**
   * 用户或企业名称 */
  public void setUserName(String userName) {
    this.userName = userName;
  }

  /**
   * 用户类型 */
  public String getUserType() {
    return this.userType;
  }

  /**
   * 用户类型 */
  public void setUserType(String userType) {
    this.userType = userType;
  }
}
