//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.blockchain.v1_0_0.model;

import java.lang.Long;
import java.util.List;
import javax.validation.constraints.NotNull;

/**
 * 批量查询商户下已映射的账户信息接口，返回的对象 */
public class QueryMappingBatchResult {
  @NotNull
  private List<AccountMappingInfo> accounts;

  @NotNull
  private Long totalNum;

  @NotNull
  private Long totalPage;

  /**
   * 本次查询获取的账户信息 */
  public List<AccountMappingInfo> getAccounts() {
    return this.accounts;
  }

  /**
   * 本次查询获取的账户信息 */
  public void setAccounts(List<AccountMappingInfo> accounts) {
    this.accounts = accounts;
  }

  /**
   * 该商户下总共映射账户的数量 */
  public Long getTotalNum() {
    return this.totalNum;
  }

  /**
   * 该商户下总共映射账户的数量 */
  public void setTotalNum(Long totalNum) {
    this.totalNum = totalNum;
  }

  /**
   * 该商户下账户信息的总页数 */
  public Long getTotalPage() {
    return this.totalPage;
  }

  /**
   * 该商户下账户信息的总页数 */
  public void setTotalPage(Long totalPage) {
    this.totalPage = totalPage;
  }
}
