//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.blockchain.v1_0_0.model;

import java.lang.String;
import javax.validation.constraints.NotNull;

/**
 * 溯源信息中的一项记录。 */
public class Item {
  @NotNull
  private String desc;

  @NotNull
  private String extInfo;

  @NotNull
  private String key;

  @NotNull
  private String title;

  @NotNull
  private String type;

  /**
   * 溯源项的具体内容 */
  public String getDesc() {
    return this.desc;
  }

  /**
   * 溯源项的具体内容 */
  public void setDesc(String desc) {
    this.desc = desc;
  }

  /**
   * 扩展信息 ，json格式 */
  public String getExtInfo() {
    return this.extInfo;
  }

  /**
   * 扩展信息 ，json格式 */
  public void setExtInfo(String extInfo) {
    this.extInfo = extInfo;
  }

  /**
   * 溯源项的键值 */
  public String getKey() {
    return this.key;
  }

  /**
   * 溯源项的键值 */
  public void setKey(String key) {
    this.key = key;
  }

  /**
   * 溯源项的中文标题  */
  public String getTitle() {
    return this.title;
  }

  /**
   * 溯源项的中文标题  */
  public void setTitle(String title) {
    this.title = title;
  }

  /**
   * 内容类型  */
  public String getType() {
    return this.type;
  }

  /**
   * 内容类型  */
  public void setType(String type) {
    this.type = type;
  }
}
