//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.blockchain.v1_0_0.model;

import java.lang.String;
import javax.validation.constraints.NotNull;

/**
 * identity parameter */
public class IdentityParam {
  private String agent;

  private String agentId;

  @NotNull
  private String certName;

  @NotNull
  private String certNo;

  @NotNull
  private String certType;

  private String legalPerson;

  private String legalPersonId;

  private String mobileNo;

  private String properties;

  private String userType;

  /**
   * 经办人姓名 */
  public String getAgent() {
    return this.agent;
  }

  /**
   * 经办人姓名 */
  public void setAgent(String agent) {
    this.agent = agent;
  }

  /**
   * 经办人身份证号 */
  public String getAgentId() {
    return this.agentId;
  }

  /**
   * 经办人身份证号 */
  public void setAgentId(String agentId) {
    this.agentId = agentId;
  }

  /**
   * 用户的姓名 */
  public String getCertName() {
    return this.certName;
  }

  /**
   * 用户的姓名 */
  public void setCertName(String certName) {
    this.certName = certName;
  }

  /**
   * 用户的身份证号 */
  public String getCertNo() {
    return this.certNo;
  }

  /**
   * 用户的身份证号 */
  public void setCertNo(String certNo) {
    this.certNo = certNo;
  }

  /**
   * 用户证件类型，目前只支持IDENTITY_CARD */
  public String getCertType() {
    return this.certType;
  }

  /**
   * 用户证件类型，目前只支持IDENTITY_CARD */
  public void setCertType(String certType) {
    this.certType = certType;
  }

  /**
   * 法人姓名，企业认证必选 */
  public String getLegalPerson() {
    return this.legalPerson;
  }

  /**
   * 法人姓名，企业认证必选 */
  public void setLegalPerson(String legalPerson) {
    this.legalPerson = legalPerson;
  }

  /**
   * 法人身份证，企业认证必选 */
  public String getLegalPersonId() {
    return this.legalPersonId;
  }

  /**
   * 法人身份证，企业认证必选 */
  public void setLegalPersonId(String legalPersonId) {
    this.legalPersonId = legalPersonId;
  }

  /**
   * 手机号码 */
  public String getMobileNo() {
    return this.mobileNo;
  }

  /**
   * 手机号码 */
  public void setMobileNo(String mobileNo) {
    this.mobileNo = mobileNo;
  }

  /**
   * 扩展属性字段 */
  public String getProperties() {
    return this.properties;
  }

  /**
   * 扩展属性字段 */
  public void setProperties(String properties) {
    this.properties = properties;
  }

  /**
   * 用户类型，默认为PERSON */
  public String getUserType() {
    return this.userType;
  }

  /**
   * 用户类型，默认为PERSON */
  public void setUserType(String userType) {
    this.userType = userType;
  }
}
