//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.blockchain.v1_0_0.model;

import java.lang.String;
import javax.validation.constraints.NotNull;

/**
 * 账户映射结果 */
public class AccountMappingResult {
  @NotNull
  private String baccount;

  @NotNull
  private String message;

  @NotNull
  private String status;

  @NotNull
  private String uid;

  /**
   * 该账户在链上的唯一标示 */
  public String getBaccount() {
    return this.baccount;
  }

  /**
   * 该账户在链上的唯一标示 */
  public void setBaccount(String baccount) {
    this.baccount = baccount;
  }

  /**
   * 当前账户映射结果描述语句 */
  public String getMessage() {
    return this.message;
  }

  /**
   * 当前账户映射结果描述语句 */
  public void setMessage(String message) {
    this.message = message;
  }

  /**
   * 状态描述符 */
  public String getStatus() {
    return this.status;
  }

  /**
   * 状态描述符 */
  public void setStatus(String status) {
    this.status = status;
  }

  /**
   * 自有系统中该账户唯一标示 */
  public String getUid() {
    return this.uid;
  }

  /**
   * 自有系统中该账户唯一标示 */
  public void setUid(String uid) {
    this.uid = uid;
  }
}
