//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.blockchain.v1_0_0.model;

import java.lang.Long;
import java.lang.String;
import javax.validation.constraints.NotNull;

/**
 * 账户映射情况 */
public class AccountMappingInfo {
  @NotNull
  private Long bindingStatus;

  @NotNull
  private Long status;

  @NotNull
  private String uid;

  /**
   * 账户绑定状态，1为未绑定，2为绑定成功 */
  public Long getBindingStatus() {
    return this.bindingStatus;
  }

  /**
   * 账户绑定状态，1为未绑定，2为绑定成功 */
  public void setBindingStatus(Long bindingStatus) {
    this.bindingStatus = bindingStatus;
  }

  /**
   * 1是激活状态，2是冻结状态 */
  public Long getStatus() {
    return this.status;
  }

  /**
   * 1是激活状态，2是冻结状态 */
  public void setStatus(Long status) {
    this.status = status;
  }

  /**
   * 账户唯一标示 */
  public String getUid() {
    return this.uid;
  }

  /**
   * 账户唯一标示 */
  public void setUid(String uid) {
    this.uid = uid;
  }
}
