//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.blockchain.v1_0_0.model;

import java.lang.Long;
import java.lang.String;
import javax.validation.constraints.NotNull;

/**
 * 账户映射的具体信息 */
public class AccountMap {
  @NotNull
  private String bizid;

  @NotNull
  private Long entityInfoType;

  @NotNull
  private String entityInfoValue;

  private String fullName;

  @NotNull
  private Long status;

  private String targetName;

  @NotNull
  private Long type;

  @NotNull
  private String uid;

  /**
   * 要映射的链对应的唯一id */
  public String getBizid() {
    return this.bizid;
  }

  /**
   * 要映射的链对应的唯一id */
  public void setBizid(String bizid) {
    this.bizid = bizid;
  }

  /**
   * 0: 身份证；1：手机；2: 电子邮箱；3: 企业营业执照号 */
  public Long getEntityInfoType() {
    return this.entityInfoType;
  }

  /**
   * 0: 身份证；1：手机；2: 电子邮箱；3: 企业营业执照号 */
  public void setEntityInfoType(Long entityInfoType) {
    this.entityInfoType = entityInfoType;
  }

  /**
   * 对应entity_info_type的具体值
   */
  public String getEntityInfoValue() {
    return this.entityInfoValue;
  }

  /**
   * 对应entity_info_type的具体值
   */
  public void setEntityInfoValue(String entityInfoValue) {
    this.entityInfoValue = entityInfoValue;
  }

  /**
   * 账户对应实体的全名 */
  public String getFullName() {
    return this.fullName;
  }

  /**
   * 账户对应实体的全名 */
  public void setFullName(String fullName) {
    this.fullName = fullName;
  }

  /**
   * 该账户在指定链上的状态1，激活，2，冻结，新建账户只能为1 */
  public Long getStatus() {
    return this.status;
  }

  /**
   * 该账户在指定链上的状态1，激活，2，冻结，新建账户只能为1 */
  public void setStatus(Long status) {
    this.status = status;
  }

  /**
   * 希望映射后在链上的账户名 */
  public String getTargetName() {
    return this.targetName;
  }

  /**
   * 希望映射后在链上的账户名 */
  public void setTargetName(String targetName) {
    this.targetName = targetName;
  }

  /**
   * 该账户对应实体的类型：0， 个人； 1， 企业 */
  public Long getType() {
    return this.type;
  }

  /**
   * 该账户对应实体的类型：0， 个人； 1， 企业 */
  public void setType(Long type) {
    this.type = type;
  }

  /**
   * 自有系统中该账户的唯一标示 */
  public String getUid() {
    return this.uid;
  }

  /**
   * 自有系统中该账户的唯一标示 */
  public void setUid(String uid) {
    this.uid = uid;
  }
}
