//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.aks.v1_0_0.response;

import cn.com.antcloud.api.antcloud.provider.AntCloudProviderResponse;
import cn.com.antcloud.api.provider.aks.v1_0_0.model.ContainerService;
import java.lang.Long;
import java.util.List;

/**
 * 查询容器服务列表
 */
public class QueryServiceResponse extends AntCloudProviderResponse<QueryServiceResponse> {
  private List<ContainerService> containerServices;

  private Long pageNum;

  private Long pageSize;

  private Long totalCount;

  /**
   * 容器服务实例列表 */
  public List<ContainerService> getContainerServices() {
    return this.containerServices;
  }

  /**
   * 容器服务实例列表 */
  public void setContainerServices(List<ContainerService> containerServices) {
    this.containerServices = containerServices;
  }

  /**
   * 当前页面 */
  public Long getPageNum() {
    return this.pageNum;
  }

  /**
   * 当前页面 */
  public void setPageNum(Long pageNum) {
    this.pageNum = pageNum;
  }

  /**
   * 分页大小 */
  public Long getPageSize() {
    return this.pageSize;
  }

  /**
   * 分页大小 */
  public void setPageSize(Long pageSize) {
    this.pageSize = pageSize;
  }

  /**
   * 应用总数 */
  public Long getTotalCount() {
    return this.totalCount;
  }

  /**
   * 应用总数 */
  public void setTotalCount(Long totalCount) {
    this.totalCount = totalCount;
  }
}
