//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.aks.v1_0_0.response;

import cn.com.antcloud.api.antcloud.provider.AntCloudProviderResponse;
import cn.com.antcloud.api.provider.aks.v1_0_0.model.ContainerServiceRevision;
import java.lang.Long;
import java.util.List;

/**
 * 查询版本列表
 */
public class QueryContainerserviceRevisionResponse extends AntCloudProviderResponse<QueryContainerserviceRevisionResponse> {
  private Long pageNum;

  private Long pageSize;

  private List<ContainerServiceRevision> revisionList;

  private Long totalCount;

  /**
   * 当前页 */
  public Long getPageNum() {
    return this.pageNum;
  }

  /**
   * 当前页 */
  public void setPageNum(Long pageNum) {
    this.pageNum = pageNum;
  }

  /**
   * 每页记录数 */
  public Long getPageSize() {
    return this.pageSize;
  }

  /**
   * 每页记录数 */
  public void setPageSize(Long pageSize) {
    this.pageSize = pageSize;
  }

  /**
   * 版本列表 */
  public List<ContainerServiceRevision> getRevisionList() {
    return this.revisionList;
  }

  /**
   * 版本列表 */
  public void setRevisionList(List<ContainerServiceRevision> revisionList) {
    this.revisionList = revisionList;
  }

  /**
   * 总记录数 */
  public Long getTotalCount() {
    return this.totalCount;
  }

  /**
   * 总记录数 */
  public void setTotalCount(Long totalCount) {
    this.totalCount = totalCount;
  }
}
