//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.aks.v1_0_0.response;

import cn.com.antcloud.api.antcloud.provider.AntCloudProviderResponse;
import java.lang.Boolean;
import java.lang.String;

/**
 * 集群创建/扩容/添加节点/删除节点等操作状态结果查询接口
 */
public class QueryClusterProgressResponse extends AntCloudProviderResponse<QueryClusterProgressResponse> {
  private String currentStep;

  private String currentTask;

  private Boolean ignorable;

  private String reason;

  private Boolean retryable;

  private String state;

  /**
   * 集群操作流程当前步骤 */
  public String getCurrentStep() {
    return this.currentStep;
  }

  /**
   * 集群操作流程当前步骤 */
  public void setCurrentStep(String currentStep) {
    this.currentStep = currentStep;
  }

  /**
   * 描述集群操作当前步骤 */
  public String getCurrentTask() {
    return this.currentTask;
  }

  /**
   * 描述集群操作当前步骤 */
  public void setCurrentTask(String currentTask) {
    this.currentTask = currentTask;
  }

  /**
   * 描述当前task是否可以失败忽略 */
  public Boolean getIgnorable() {
    return this.ignorable;
  }

  /**
   * 描述当前task是否可以失败忽略 */
  public void setIgnorable(Boolean ignorable) {
    this.ignorable = ignorable;
  }

  /**
   * 原因 */
  public String getReason() {
    return this.reason;
  }

  /**
   * 原因 */
  public void setReason(String reason) {
    this.reason = reason;
  }

  /**
   * 描述当前task是否可失败重试 */
  public Boolean getRetryable() {
    return this.retryable;
  }

  /**
   * 描述当前task是否可失败重试 */
  public void setRetryable(Boolean retryable) {
    this.retryable = retryable;
  }

  /**
   * 集群运维单状态 */
  public String getState() {
    return this.state;
  }

  /**
   * 集群运维单状态 */
  public void setState(String state) {
    this.state = state;
  }
}
