//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.aks.v1_0_0.response;

import cn.com.antcloud.api.antcloud.provider.AntCloudProviderResponse;
import cn.com.antcloud.api.provider.aks.v1_0_0.model.OpsContainerServiceChain;
import java.lang.String;
import java.util.List;

/**
 * 获取发布单详情，该接口只能查询发布单下容器服务的基本执行状态(name, revision, status) 如果需要更详细的发布进度，请通过
 * antcloud.aks.deployment.service.get 查询
 */
public class GetDeploymentResponse extends AntCloudProviderResponse<GetDeploymentResponse> {
  private List<OpsContainerServiceChain> containerServiceChains;

  private String executor;

  private String status;

  /**
   * 此部署操作中所有被操作的容器服务详情，以操作链的形式体现 */
  public List<OpsContainerServiceChain> getContainerServiceChains() {
    return this.containerServiceChains;
  }

  /**
   * 此部署操作中所有被操作的容器服务详情，以操作链的形式体现 */
  public void setContainerServiceChains(List<OpsContainerServiceChain> containerServiceChains) {
    this.containerServiceChains = containerServiceChains;
  }

  /**
   * 部署操作执行者 */
  public String getExecutor() {
    return this.executor;
  }

  /**
   * 部署操作执行者 */
  public void setExecutor(String executor) {
    this.executor = executor;
  }

  /**
   * 部署单状态。取值列表：INITING：初始化中；INIT_FAILED：初始化失败；INITED：初始化完成；EXECUTING：执行中；SUCCESS：执行成功；FAILED：执行失败；CANCELING：取消中；CANCELED：已取消 */
  public String getStatus() {
    return this.status;
  }

  /**
   * 部署单状态。取值列表：INITING：初始化中；INIT_FAILED：初始化失败；INITED：初始化完成；EXECUTING：执行中；SUCCESS：执行成功；FAILED：执行失败；CANCELING：取消中；CANCELED：已取消 */
  public void setStatus(String status) {
    this.status = status;
  }
}
