//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.aks.v1_0_0.request;

import cn.com.antcloud.api.antcloud.provider.AntCloudProviderRequest;
import cn.com.antcloud.api.provider.aks.v1_0_0.response.UpdateServiceResponse;
import java.lang.Long;
import java.lang.String;
import javax.validation.constraints.NotNull;

/**
 * 更新已有的容器服务实例
 */
public class UpdateServiceRequest extends AntCloudProviderRequest<UpdateServiceResponse> {
  @NotNull
  private String containerConfigs;

  @NotNull
  private String containerServiceName;

  @NotNull
  private Long replicas;

  public UpdateServiceRequest() {
    super("antcloud.aks.service.update", "1.0", "Java-SDK-20190814");
  }

  /**
   * 容器配置 */
  public String getContainerConfigs() {
    return this.containerConfigs;
  }

  /**
   * 容器配置 */
  public void setContainerConfigs(String containerConfigs) {
    this.containerConfigs = containerConfigs;
  }

  /**
   * 容器服务实例名称 */
  public String getContainerServiceName() {
    return this.containerServiceName;
  }

  /**
   * 容器服务实例名称 */
  public void setContainerServiceName(String containerServiceName) {
    this.containerServiceName = containerServiceName;
  }

  /**
   * 副本数量 */
  public Long getReplicas() {
    return this.replicas;
  }

  /**
   * 副本数量 */
  public void setReplicas(Long replicas) {
    this.replicas = replicas;
  }
}
