//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.aks.v1_0_0.request;

import cn.com.antcloud.api.antcloud.provider.AntCloudProviderRequest;
import cn.com.antcloud.api.provider.aks.v1_0_0.model.ContainerServiceConfig;
import cn.com.antcloud.api.provider.aks.v1_0_0.response.UpdateContainerserviceResponse;
import java.lang.String;
import java.util.Date;
import javax.validation.constraints.NotNull;

/**
 * 更新容器服务配置
 */
public class UpdateContainerserviceRequest extends AntCloudProviderRequest<UpdateContainerserviceResponse> {
  @NotNull
  private ContainerServiceConfig config;

  @NotNull
  private Date draftedTime;

  @NotNull
  private String name;

  @NotNull
  private String operator;

  @NotNull
  private String workspace;

  public UpdateContainerserviceRequest() {
    super("antcloud.aks.containerservice.update", "1.0", "Java-SDK-20190814");
  }

  /**
   * 应用服务的配置 */
  public ContainerServiceConfig getConfig() {
    return this.config;
  }

  /**
   * 应用服务的配置 */
  public void setConfig(ContainerServiceConfig config) {
    this.config = config;
  }

  /**
   * 最近一次的草稿时间 */
  public Date getDraftedTime() {
    return this.draftedTime;
  }

  /**
   * 最近一次的草稿时间 */
  public void setDraftedTime(Date draftedTime) {
    this.draftedTime = draftedTime;
  }

  /**
   * 指定修改的容器服务名 */
  public String getName() {
    return this.name;
  }

  /**
   * 指定修改的容器服务名 */
  public void setName(String name) {
    this.name = name;
  }

  /**
   * 操作人 */
  public String getOperator() {
    return this.operator;
  }

  /**
   * 操作人 */
  public void setOperator(String operator) {
    this.operator = operator;
  }

  /**
   * 工作空间名 */
  public String getWorkspace() {
    return this.workspace;
  }

  /**
   * 工作空间名 */
  public void setWorkspace(String workspace) {
    this.workspace = workspace;
  }
}
