//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.aks.v1_0_0.request;

import cn.com.antcloud.api.antcloud.provider.AntCloudProviderRequest;
import cn.com.antcloud.api.provider.aks.v1_0_0.model.NodeCreationInfo;
import cn.com.antcloud.api.provider.aks.v1_0_0.response.ScaleClusterNodeResponse;
import java.lang.String;
import java.util.List;
import javax.validation.constraints.NotNull;

/**
 * 集群节点扩容，新建ECS然后倒入集群
 */
public class ScaleClusterNodeRequest extends AntCloudProviderRequest<ScaleClusterNodeResponse> {
  @NotNull
  private List<NodeCreationInfo> nodeCreationInfos;

  @NotNull
  private String operatorName;

  @NotNull
  private String workspace;

  public ScaleClusterNodeRequest() {
    super("antcloud.aks.cluster.node.scale", "1.0", "Java-SDK-20190814");
  }

  /**
   * 集群ECS节点创建信息 */
  public List<NodeCreationInfo> getNodeCreationInfos() {
    return this.nodeCreationInfos;
  }

  /**
   * 集群ECS节点创建信息 */
  public void setNodeCreationInfos(List<NodeCreationInfo> nodeCreationInfos) {
    this.nodeCreationInfos = nodeCreationInfos;
  }

  /**
   * 操作人名称 */
  public String getOperatorName() {
    return this.operatorName;
  }

  /**
   * 操作人名称 */
  public void setOperatorName(String operatorName) {
    this.operatorName = operatorName;
  }

  /**
   * 工作空间名称 */
  public String getWorkspace() {
    return this.workspace;
  }

  /**
   * 工作空间名称 */
  public void setWorkspace(String workspace) {
    this.workspace = workspace;
  }
}
