//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.aks.v1_0_0.request;

import cn.com.antcloud.api.antcloud.provider.AntCloudProviderRequest;
import cn.com.antcloud.api.provider.aks.v1_0_0.response.RollbackDeploymentServiceResponse;
import java.lang.String;
import javax.validation.constraints.NotNull;

/**
 * 取消此次容器服务发布并回滚至上一次成功发布的版本
 */
public class RollbackDeploymentServiceRequest extends AntCloudProviderRequest<RollbackDeploymentServiceResponse> {
  @NotNull
  private String containerServiceName;

  @NotNull
  private String operationId;

  @NotNull
  private String reason;

  public RollbackDeploymentServiceRequest() {
    super("antcloud.aks.deployment.service.rollback", "1.0", "Java-SDK-20190814");
  }

  /**
   * 发布单中的容器服务名称 */
  public String getContainerServiceName() {
    return this.containerServiceName;
  }

  /**
   * 发布单中的容器服务名称 */
  public void setContainerServiceName(String containerServiceName) {
    this.containerServiceName = containerServiceName;
  }

  /**
   * 部署单id */
  public String getOperationId() {
    return this.operationId;
  }

  /**
   * 部署单id */
  public void setOperationId(String operationId) {
    this.operationId = operationId;
  }

  /**
   * 回滚原因 */
  public String getReason() {
    return this.reason;
  }

  /**
   * 回滚原因 */
  public void setReason(String reason) {
    this.reason = reason;
  }
}
