//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.aks.v1_0_0.request;

import cn.com.antcloud.api.antcloud.provider.AntCloudProviderRequest;
import cn.com.antcloud.api.provider.aks.v1_0_0.response.RetryDeploymentResponse;
import java.lang.String;
import javax.validation.constraints.NotNull;

/**
 * 对一个部署操作中所有部署失败的分组进行重试操作。
 * 当部署单处于以下状态时可执行重试操作：
 * FAILED：执行失败
 */
public class RetryDeploymentRequest extends AntCloudProviderRequest<RetryDeploymentResponse> {
  @NotNull
  private String operationId;

  public RetryDeploymentRequest() {
    super("antcloud.aks.deployment.retry", "1.0", "Java-SDK-20190814");
  }

  /**
   * 部署单id
   */
  public String getOperationId() {
    return this.operationId;
  }

  /**
   * 部署单id
   */
  public void setOperationId(String operationId) {
    this.operationId = operationId;
  }
}
