//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.aks.v1_0_0.request;

import cn.com.antcloud.api.antcloud.provider.AntCloudProviderRequest;
import cn.com.antcloud.api.provider.aks.v1_0_0.response.QueryServiceResponse;
import java.lang.Long;
import java.lang.String;
import javax.validation.constraints.NotNull;

/**
 * 查询容器服务列表
 */
public class QueryServiceRequest extends AntCloudProviderRequest<QueryServiceResponse> {
  @NotNull
  private String containerServiceName;

  @NotNull
  private Long pageNum;

  @NotNull
  private Long pageSize;

  public QueryServiceRequest() {
    super("antcloud.aks.service.query", "1.0", "Java-SDK-20190814");
  }

  /**
   * 待查询容器名 */
  public String getContainerServiceName() {
    return this.containerServiceName;
  }

  /**
   * 待查询容器名 */
  public void setContainerServiceName(String containerServiceName) {
    this.containerServiceName = containerServiceName;
  }

  /**
   * 当前页码 */
  public Long getPageNum() {
    return this.pageNum;
  }

  /**
   * 当前页码 */
  public void setPageNum(Long pageNum) {
    this.pageNum = pageNum;
  }

  /**
   * 分页大小，默认10，最大50 */
  public Long getPageSize() {
    return this.pageSize;
  }

  /**
   * 分页大小，默认10，最大50 */
  public void setPageSize(Long pageSize) {
    this.pageSize = pageSize;
  }
}
