//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.aks.v1_0_0.request;

import cn.com.antcloud.api.antcloud.provider.AntCloudProviderRequest;
import cn.com.antcloud.api.provider.aks.v1_0_0.response.QueryEventPodResponse;
import java.lang.String;
import java.util.Date;
import javax.validation.constraints.NotNull;

/**
 * 查询 pod event
 */
public class QueryEventPodRequest extends AntCloudProviderRequest<QueryEventPodResponse> {
  @NotNull
  private Date from;

  @NotNull
  private Date to;

  @NotNull
  private String uid;

  public QueryEventPodRequest() {
    super("antcloud.aks.event.pod.query", "1.0", "Java-SDK-20190814");
  }

  /**
   * event 查询起始时间 */
  public Date getFrom() {
    return this.from;
  }

  /**
   * event 查询起始时间 */
  public void setFrom(Date from) {
    this.from = from;
  }

  /**
   * event 查询截止时间 */
  public Date getTo() {
    return this.to;
  }

  /**
   * event 查询截止时间 */
  public void setTo(Date to) {
    this.to = to;
  }

  /**
   * pod uid */
  public String getUid() {
    return this.uid;
  }

  /**
   * pod uid */
  public void setUid(String uid) {
    this.uid = uid;
  }
}
