//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.aks.v1_0_0.request;

import cn.com.antcloud.api.antcloud.provider.AntCloudProviderRequest;
import cn.com.antcloud.api.provider.aks.v1_0_0.response.QueryContainerserviceRevisionResponse;
import java.lang.Long;
import java.lang.String;
import java.util.List;
import javax.validation.constraints.NotNull;

/**
 * 查询版本列表
 */
public class QueryContainerserviceRevisionRequest extends AntCloudProviderRequest<QueryContainerserviceRevisionResponse> {
  @NotNull
  private String cluster;

  private List<String> deployStatus;

  private List<String> metaStatus;

  @NotNull
  private String name;

  private Long pageNum;

  private Long pageSize;

  @NotNull
  private String workspace;

  public QueryContainerserviceRevisionRequest() {
    super("antcloud.aks.containerservice.revision.query", "1.0", "Java-SDK-20190814");
  }

  /**
   * 集群名 */
  public String getCluster() {
    return this.cluster;
  }

  /**
   * 集群名 */
  public void setCluster(String cluster) {
    this.cluster = cluster;
  }

  /**
   * 发布状态筛选 */
  public List<String> getDeployStatus() {
    return this.deployStatus;
  }

  /**
   * 发布状态筛选 */
  public void setDeployStatus(List<String> deployStatus) {
    this.deployStatus = deployStatus;
  }

  /**
   * 版本状态筛选 */
  public List<String> getMetaStatus() {
    return this.metaStatus;
  }

  /**
   * 版本状态筛选 */
  public void setMetaStatus(List<String> metaStatus) {
    this.metaStatus = metaStatus;
  }

  /**
   * 容器服务名 */
  public String getName() {
    return this.name;
  }

  /**
   * 容器服务名 */
  public void setName(String name) {
    this.name = name;
  }

  /**
   * 当前页 */
  public Long getPageNum() {
    return this.pageNum;
  }

  /**
   * 当前页 */
  public void setPageNum(Long pageNum) {
    this.pageNum = pageNum;
  }

  /**
   * 每页记录数 */
  public Long getPageSize() {
    return this.pageSize;
  }

  /**
   * 每页记录数 */
  public void setPageSize(Long pageSize) {
    this.pageSize = pageSize;
  }

  /**
   * 工作空间 */
  public String getWorkspace() {
    return this.workspace;
  }

  /**
   * 工作空间 */
  public void setWorkspace(String workspace) {
    this.workspace = workspace;
  }
}
