//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.aks.v1_0_0.request;

import cn.com.antcloud.api.antcloud.provider.AntCloudProviderRequest;
import cn.com.antcloud.api.provider.aks.v1_0_0.response.QueryContainerserviceResponse;
import java.lang.Boolean;
import java.lang.Long;
import java.lang.String;
import java.util.List;
import javax.validation.constraints.NotNull;

/**
 * 查询容器服务列表
 */
public class QueryContainerserviceRequest extends AntCloudProviderRequest<QueryContainerserviceResponse> {
  @NotNull
  private String cluster;

  private List<String> deployStatus;

  private Boolean enableMesh;

  private List<String> metaStatus;

  private String name;

  @NotNull
  private String namespace;

  private Long pageNum;

  private Long pageSize;

  private String queryType;

  @NotNull
  private String workspace;

  public QueryContainerserviceRequest() {
    super("antcloud.aks.containerservice.query", "1.0", "Java-SDK-20190814");
  }

  /**
   * 集群名 */
  public String getCluster() {
    return this.cluster;
  }

  /**
   * 集群名 */
  public void setCluster(String cluster) {
    this.cluster = cluster;
  }

  /**
   * 发布状态筛选 */
  public List<String> getDeployStatus() {
    return this.deployStatus;
  }

  /**
   * 发布状态筛选 */
  public void setDeployStatus(List<String> deployStatus) {
    this.deployStatus = deployStatus;
  }

  /**
   * 是否开启mesh */
  public Boolean getEnableMesh() {
    return this.enableMesh;
  }

  /**
   * 是否开启mesh */
  public void setEnableMesh(Boolean enableMesh) {
    this.enableMesh = enableMesh;
  }

  /**
   * 容器服务状态筛选 */
  public List<String> getMetaStatus() {
    return this.metaStatus;
  }

  /**
   * 容器服务状态筛选 */
  public void setMetaStatus(List<String> metaStatus) {
    this.metaStatus = metaStatus;
  }

  /**
   * 容器服务名 */
  public String getName() {
    return this.name;
  }

  /**
   * 容器服务名 */
  public void setName(String name) {
    this.name = name;
  }

  /**
   * 命名空间 */
  public String getNamespace() {
    return this.namespace;
  }

  /**
   * 命名空间 */
  public void setNamespace(String namespace) {
    this.namespace = namespace;
  }

  /**
   * 当前页，默认1 */
  public Long getPageNum() {
    return this.pageNum;
  }

  /**
   * 当前页，默认1 */
  public void setPageNum(Long pageNum) {
    this.pageNum = pageNum;
  }

  /**
   * 每页记录数，默认20 */
  public Long getPageSize() {
    return this.pageSize;
  }

  /**
   * 每页记录数，默认20 */
  public void setPageSize(Long pageSize) {
    this.pageSize = pageSize;
  }

  /**
   * 是否模糊查询，默认 FUZZY（模糊查询） */
  public String getQueryType() {
    return this.queryType;
  }

  /**
   * 是否模糊查询，默认 FUZZY（模糊查询） */
  public void setQueryType(String queryType) {
    this.queryType = queryType;
  }

  /**
   * 工作空间 */
  public String getWorkspace() {
    return this.workspace;
  }

  /**
   * 工作空间 */
  public void setWorkspace(String workspace) {
    this.workspace = workspace;
  }
}
