//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.aks.v1_0_0.request;

import cn.com.antcloud.api.antcloud.provider.AntCloudProviderRequest;
import cn.com.antcloud.api.provider.aks.v1_0_0.response.QueryClusterProgressResponse;
import java.lang.String;
import javax.validation.constraints.NotNull;

/**
 * 集群创建/扩容/添加节点/删除节点等操作状态结果查询接口
 */
public class QueryClusterProgressRequest extends AntCloudProviderRequest<QueryClusterProgressResponse> {
  @NotNull
  private String id;

  @NotNull
  private String operationType;

  public QueryClusterProgressRequest() {
    super("antcloud.aks.cluster.progress.query", "1.0", "Java-SDK-20190814");
  }

  /**
   * 集群运维单id */
  public String getId() {
    return this.id;
  }

  /**
   * 集群运维单id */
  public void setId(String id) {
    this.id = id;
  }

  /**
   * 集群操作类型，枚举，CREATE/SCALE_NODE/ADD_NODE/BATCH_DELETE_NODE等 */
  public String getOperationType() {
    return this.operationType;
  }

  /**
   * 集群操作类型，枚举，CREATE/SCALE_NODE/ADD_NODE/BATCH_DELETE_NODE等 */
  public void setOperationType(String operationType) {
    this.operationType = operationType;
  }
}
