//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.aks.v1_0_0.request;

import cn.com.antcloud.api.antcloud.provider.AntCloudProviderRequest;
import cn.com.antcloud.api.provider.aks.v1_0_0.response.ListDeploymentServiceResponse;
import java.lang.String;
import java.util.Date;
import javax.validation.constraints.NotNull;

/**
 * 查询应用的发布记录，最多查询100条记录 */
public class ListDeploymentServiceRequest extends AntCloudProviderRequest<ListDeploymentServiceResponse> {
  @NotNull
  private String containerServiceName;

  @NotNull
  private Date from;

  @NotNull
  private Date to;

  public ListDeploymentServiceRequest() {
    super("antcloud.aks.deployment.service.list", "1.0", "Java-SDK-20190814");
  }

  /**
   * 查询的容器服务（精确）名称 */
  public String getContainerServiceName() {
    return this.containerServiceName;
  }

  /**
   * 查询的容器服务（精确）名称 */
  public void setContainerServiceName(String containerServiceName) {
    this.containerServiceName = containerServiceName;
  }

  /**
   * 查询起始时间 */
  public Date getFrom() {
    return this.from;
  }

  /**
   * 查询起始时间 */
  public void setFrom(Date from) {
    this.from = from;
  }

  /**
   * 查询结束时间 */
  public Date getTo() {
    return this.to;
  }

  /**
   * 查询结束时间 */
  public void setTo(Date to) {
    this.to = to;
  }
}
