//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.aks.v1_0_0.request;

import cn.com.antcloud.api.antcloud.provider.AntCloudProviderRequest;
import cn.com.antcloud.api.provider.aks.v1_0_0.response.ListBuildConfigResponse;
import java.lang.Long;

/**
 * 展示构建应用列表
 */
public class ListBuildConfigRequest extends AntCloudProviderRequest<ListBuildConfigResponse> {
  private Long pageNum;

  private Long pageSize;

  public ListBuildConfigRequest() {
    super("antcloud.aks.build.config.list", "1.0", "Java-SDK-20190814");
  }

  /**
   * page_num */
  public Long getPageNum() {
    return this.pageNum;
  }

  /**
   * page_num */
  public void setPageNum(Long pageNum) {
    this.pageNum = pageNum;
  }

  /**
   * page_size */
  public Long getPageSize() {
    return this.pageSize;
  }

  /**
   * page_size */
  public void setPageSize(Long pageSize) {
    this.pageSize = pageSize;
  }
}
