//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.aks.v1_0_0.request;

import cn.com.antcloud.api.antcloud.provider.AntCloudProviderRequest;
import cn.com.antcloud.api.provider.aks.v1_0_0.response.InitWorkspaceResponse;
import java.lang.String;
import javax.validation.constraints.NotNull;

/**
 * 初始化指定workspace下容器化部署的相关配置
 */
public class InitWorkspaceRequest extends AntCloudProviderRequest<InitWorkspaceResponse> {
  @NotNull
  private String namespace;

  @NotNull
  private String tenant;

  @NotNull
  private String workspace;

  public InitWorkspaceRequest() {
    super("antcloud.aks.workspace.init", "1.0", "Java-SDK-20190814");
  }

  /**
   * namespace名称，建议将租户名和workspace名称组装作
   * 为namespace名称,namespace命名规范：[a-z0-9]([-a-z0-9]*[a-z0-9])? */
  public String getNamespace() {
    return this.namespace;
  }

  /**
   * namespace名称，建议将租户名和workspace名称组装作
   * 为namespace名称,namespace命名规范：[a-z0-9]([-a-z0-9]*[a-z0-9])? */
  public void setNamespace(String namespace) {
    this.namespace = namespace;
  }

  /**
   * 目标租户名称 */
  public String getTenant() {
    return this.tenant;
  }

  /**
   * 目标租户名称 */
  public void setTenant(String tenant) {
    this.tenant = tenant;
  }

  /**
   * 环境名称 */
  public String getWorkspace() {
    return this.workspace;
  }

  /**
   * 环境名称 */
  public void setWorkspace(String workspace) {
    this.workspace = workspace;
  }
}
