//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.aks.v1_0_0.request;

import cn.com.antcloud.api.antcloud.provider.AntCloudProviderRequest;
import cn.com.antcloud.api.provider.aks.v1_0_0.response.GetServicePodsResponse;
import java.lang.String;
import javax.validation.constraints.NotNull;

/**
 * 获取容器服务的pod列表
 */
public class GetServicePodsRequest extends AntCloudProviderRequest<GetServicePodsResponse> {
  @NotNull
  private String containerServiceName;

  public GetServicePodsRequest() {
    super("antcloud.aks.service.pods.get", "1.0", "Java-SDK-20190814");
  }

  /**
   * container_service_name */
  public String getContainerServiceName() {
    return this.containerServiceName;
  }

  /**
   * container_service_name */
  public void setContainerServiceName(String containerServiceName) {
    this.containerServiceName = containerServiceName;
  }
}
