//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.aks.v1_0_0.request;

import cn.com.antcloud.api.antcloud.provider.AntCloudProviderRequest;
import cn.com.antcloud.api.provider.aks.v1_0_0.response.GetBuildLogResponse;
import java.lang.Long;
import java.lang.String;
import javax.validation.constraints.NotNull;

/**
 * 获取构建日志
 */
public class GetBuildLogRequest extends AntCloudProviderRequest<GetBuildLogResponse> {
  @NotNull
  private String appId;

  @NotNull
  private Long buildNumber;

  public GetBuildLogRequest() {
    super("antcloud.aks.build.log.get", "1.0", "Java-SDK-20190814");
  }

  /**
   * app_id */
  public String getAppId() {
    return this.appId;
  }

  /**
   * app_id */
  public void setAppId(String appId) {
    this.appId = appId;
  }

  /**
   * build_number */
  public Long getBuildNumber() {
    return this.buildNumber;
  }

  /**
   * build_number */
  public void setBuildNumber(Long buildNumber) {
    this.buildNumber = buildNumber;
  }
}
