//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.aks.v1_0_0.request;

import cn.com.antcloud.api.antcloud.provider.AntCloudProviderRequest;
import cn.com.antcloud.api.provider.aks.v1_0_0.model.Tuple;
import cn.com.antcloud.api.provider.aks.v1_0_0.response.ExecBuildResponse;
import java.lang.Boolean;
import java.lang.String;
import java.util.List;
import javax.validation.constraints.NotNull;

/**
 * 创建一次构建
 */
public class ExecBuildRequest extends AntCloudProviderRequest<ExecBuildResponse> {
  @NotNull
  private String appId;

  private List<Tuple> buildArgs;

  private Boolean dockerSecurityBenchmark;

  @NotNull
  private String scmBranch;

  private String scmUrl;

  public ExecBuildRequest() {
    super("antcloud.aks.build.exec", "1.0", "Java-SDK-20190814");
  }

  /**
   * 应用ID */
  public String getAppId() {
    return this.appId;
  }

  /**
   * 应用ID */
  public void setAppId(String appId) {
    this.appId = appId;
  }

  /**
   * 构建参数 */
  public List<Tuple> getBuildArgs() {
    return this.buildArgs;
  }

  /**
   * 构建参数 */
  public void setBuildArgs(List<Tuple> buildArgs) {
    this.buildArgs = buildArgs;
  }

  /**
   * 是否开启安全扫描 */
  public Boolean getDockerSecurityBenchmark() {
    return this.dockerSecurityBenchmark;
  }

  /**
   * 是否开启安全扫描 */
  public void setDockerSecurityBenchmark(Boolean dockerSecurityBenchmark) {
    this.dockerSecurityBenchmark = dockerSecurityBenchmark;
  }

  /**
   * 代码分支 */
  public String getScmBranch() {
    return this.scmBranch;
  }

  /**
   * 代码分支 */
  public void setScmBranch(String scmBranch) {
    this.scmBranch = scmBranch;
  }

  /**
   * 代码地址 */
  public String getScmUrl() {
    return this.scmUrl;
  }

  /**
   * 代码地址 */
  public void setScmUrl(String scmUrl) {
    this.scmUrl = scmUrl;
  }
}
