//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.aks.v1_0_0.request;

import cn.com.antcloud.api.antcloud.provider.AntCloudProviderRequest;
import cn.com.antcloud.api.provider.aks.v1_0_0.response.DescribeContainerserviceRevisionResponse;
import java.lang.String;
import javax.validation.constraints.NotNull;

/**
 * 为某一版本加上备注
 */
public class DescribeContainerserviceRevisionRequest extends AntCloudProviderRequest<DescribeContainerserviceRevisionResponse> {
  @NotNull
  private String name;

  @NotNull
  private String remarks;

  @NotNull
  private String revision;

  @NotNull
  private String workspace;

  public DescribeContainerserviceRevisionRequest() {
    super("antcloud.aks.containerservice.revision.describe", "1.0", "Java-SDK-20190814");
  }

  /**
   * 容器服务名 */
  public String getName() {
    return this.name;
  }

  /**
   * 容器服务名 */
  public void setName(String name) {
    this.name = name;
  }

  /**
   * 备注信息 */
  public String getRemarks() {
    return this.remarks;
  }

  /**
   * 备注信息 */
  public void setRemarks(String remarks) {
    this.remarks = remarks;
  }

  /**
   * 版本号 */
  public String getRevision() {
    return this.revision;
  }

  /**
   * 版本号 */
  public void setRevision(String revision) {
    this.revision = revision;
  }

  /**
   * 工作空间 */
  public String getWorkspace() {
    return this.workspace;
  }

  /**
   * 工作空间 */
  public void setWorkspace(String workspace) {
    this.workspace = workspace;
  }
}
