//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.aks.v1_0_0.request;

import cn.com.antcloud.api.antcloud.provider.AntCloudProviderRequest;
import cn.com.antcloud.api.provider.aks.v1_0_0.response.DeleteContainerserviceResponse;
import java.lang.String;
import java.util.Date;
import javax.validation.constraints.NotNull;

/**
 * 删除应用服务
 */
public class DeleteContainerserviceRequest extends AntCloudProviderRequest<DeleteContainerserviceResponse> {
  @NotNull
  private Date draftedTime;

  @NotNull
  private String name;

  @NotNull
  private String operator;

  @NotNull
  private String workspace;

  public DeleteContainerserviceRequest() {
    super("antcloud.aks.containerservice.delete", "1.0", "Java-SDK-20190814");
  }

  /**
   * 最近一次草稿时间 */
  public Date getDraftedTime() {
    return this.draftedTime;
  }

  /**
   * 最近一次草稿时间 */
  public void setDraftedTime(Date draftedTime) {
    this.draftedTime = draftedTime;
  }

  /**
   * 指定容器服务名 */
  public String getName() {
    return this.name;
  }

  /**
   * 指定容器服务名 */
  public void setName(String name) {
    this.name = name;
  }

  /**
   * 提交人 */
  public String getOperator() {
    return this.operator;
  }

  /**
   * 提交人 */
  public void setOperator(String operator) {
    this.operator = operator;
  }

  /**
   * 工作空间 */
  public String getWorkspace() {
    return this.workspace;
  }

  /**
   * 工作空间 */
  public void setWorkspace(String workspace) {
    this.workspace = workspace;
  }
}
