//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.aks.v1_0_0.request;

import cn.com.antcloud.api.antcloud.provider.AntCloudProviderRequest;
import cn.com.antcloud.api.provider.aks.v1_0_0.response.DeleteClusterNamespaceResponse;
import java.lang.String;
import javax.validation.constraints.NotNull;

/**
 * 删除单个namespace
 */
public class DeleteClusterNamespaceRequest extends AntCloudProviderRequest<DeleteClusterNamespaceResponse> {
  @NotNull
  private String name;

  @NotNull
  private String workspace;

  public DeleteClusterNamespaceRequest() {
    super("antcloud.aks.cluster.namespace.delete", "1.0", "Java-SDK-20190814");
  }

  /**
   * namespace 名称 */
  public String getName() {
    return this.name;
  }

  /**
   * namespace 名称 */
  public void setName(String name) {
    this.name = name;
  }

  /**
   * 工作空间名称 */
  public String getWorkspace() {
    return this.workspace;
  }

  /**
   * 工作空间名称 */
  public void setWorkspace(String workspace) {
    this.workspace = workspace;
  }
}
