//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.aks.v1_0_0.request;

import cn.com.antcloud.api.antcloud.provider.AntCloudProviderRequest;
import cn.com.antcloud.api.provider.aks.v1_0_0.response.DeleteBuildConfigResponse;
import java.lang.Boolean;
import java.lang.String;
import javax.validation.constraints.NotNull;

/**
 * 解除关联构建
 */
public class DeleteBuildConfigRequest extends AntCloudProviderRequest<DeleteBuildConfigResponse> {
  @NotNull
  private String appId;

  @NotNull
  private Boolean deleteImage;

  public DeleteBuildConfigRequest() {
    super("antcloud.aks.build.config.delete", "1.0", "Java-SDK-20190814");
  }

  /**
   * app ID */
  public String getAppId() {
    return this.appId;
  }

  /**
   * app ID */
  public void setAppId(String appId) {
    this.appId = appId;
  }

  /**
   * 是否删除镜像 */
  public Boolean getDeleteImage() {
    return this.deleteImage;
  }

  /**
   * 是否删除镜像 */
  public void setDeleteImage(Boolean deleteImage) {
    this.deleteImage = deleteImage;
  }
}
