//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.aks.v1_0_0.request;

import cn.com.antcloud.api.antcloud.provider.AntCloudProviderRequest;
import cn.com.antcloud.api.provider.aks.v1_0_0.response.CreateServiceResponse;
import java.lang.Boolean;
import java.lang.Long;
import java.lang.String;
import java.util.List;
import javax.validation.constraints.NotNull;

/**
 * 创建一个容器服务实例
 */
public class CreateServiceRequest extends AntCloudProviderRequest<CreateServiceResponse> {
  @NotNull
  private String applicationName;

  @NotNull
  private List<String> cellIds;

  @NotNull
  private String containerConfigs;

  @NotNull
  private String containerServiceName;

  private String description;

  @NotNull
  private Boolean enableMesh;

  private String ownerLoginName;

  @NotNull
  private Long replicas;

  public CreateServiceRequest() {
    super("antcloud.aks.service.create", "1.0", "Java-SDK-20190814");
  }

  /**
   * 应用名称 */
  public String getApplicationName() {
    return this.applicationName;
  }

  /**
   * 应用名称 */
  public void setApplicationName(String applicationName) {
    this.applicationName = applicationName;
  }

  /**
   * 关联的部署单元paas id，如果不指定则默认关联当前环境下所有部署单元 */
  public List<String> getCellIds() {
    return this.cellIds;
  }

  /**
   * 关联的部署单元paas id，如果不指定则默认关联当前环境下所有部署单元 */
  public void setCellIds(List<String> cellIds) {
    this.cellIds = cellIds;
  }

  /**
   * 容器配置 */
  public String getContainerConfigs() {
    return this.containerConfigs;
  }

  /**
   * 容器配置 */
  public void setContainerConfigs(String containerConfigs) {
    this.containerConfigs = containerConfigs;
  }

  /**
   * 容器服务实例名称 */
  public String getContainerServiceName() {
    return this.containerServiceName;
  }

  /**
   * 容器服务实例名称 */
  public void setContainerServiceName(String containerServiceName) {
    this.containerServiceName = containerServiceName;
  }

  /**
   * 服务实例描述 */
  public String getDescription() {
    return this.description;
  }

  /**
   * 服务实例描述 */
  public void setDescription(String description) {
    this.description = description;
  }

  /**
   * 是否开启mesh
   */
  public Boolean getEnableMesh() {
    return this.enableMesh;
  }

  /**
   * 是否开启mesh
   */
  public void setEnableMesh(Boolean enableMesh) {
    this.enableMesh = enableMesh;
  }

  /**
   * 负责人登录名，建议指定 */
  public String getOwnerLoginName() {
    return this.ownerLoginName;
  }

  /**
   * 负责人登录名，建议指定 */
  public void setOwnerLoginName(String ownerLoginName) {
    this.ownerLoginName = ownerLoginName;
  }

  /**
   * 副本数量 */
  public Long getReplicas() {
    return this.replicas;
  }

  /**
   * 副本数量 */
  public void setReplicas(Long replicas) {
    this.replicas = replicas;
  }
}
