//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.aks.v1_0_0.request;

import cn.com.antcloud.api.antcloud.provider.AntCloudProviderRequest;
import cn.com.antcloud.api.provider.aks.v1_0_0.response.CreateMinionclusterResponse;
import java.lang.String;
import javax.validation.constraints.NotNull;

/**
 * 创建或初始化一个minioncluster集群
 */
public class CreateMinionclusterRequest extends AntCloudProviderRequest<CreateMinionclusterResponse> {
  @NotNull
  private String createType;

  private String displayName;

  @NotNull
  private String name;

  private String sourceWorkspace;

  public CreateMinionclusterRequest() {
    super("antcloud.aks.minioncluster.create", "1.0", "Java-SDK-20190814");
  }

  /**
   * 创建minioncluster类型，取值：
   * CREATE_NEW: 创建新的minioncluster
   * RE_USE: 复用另一个workspace的minioncluster配置 */
  public String getCreateType() {
    return this.createType;
  }

  /**
   * 创建minioncluster类型，取值：
   * CREATE_NEW: 创建新的minioncluster
   * RE_USE: 复用另一个workspace的minioncluster配置 */
  public void setCreateType(String createType) {
    this.createType = createType;
  }

  /**
   * minicluster的描述
   */
  public String getDisplayName() {
    return this.displayName;
  }

  /**
   * minicluster的描述
   */
  public void setDisplayName(String displayName) {
    this.displayName = displayName;
  }

  /**
   * minicluster的名称 */
  public String getName() {
    return this.name;
  }

  /**
   * minicluster的名称 */
  public void setName(String name) {
    this.name = name;
  }

  /**
   * 复用minioncluster配置时的来源workspace名称。
   * 当create_type为RE_USE时，必填 */
  public String getSourceWorkspace() {
    return this.sourceWorkspace;
  }

  /**
   * 复用minioncluster配置时的来源workspace名称。
   * 当create_type为RE_USE时，必填 */
  public void setSourceWorkspace(String sourceWorkspace) {
    this.sourceWorkspace = sourceWorkspace;
  }
}
