//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.aks.v1_0_0.request;

import cn.com.antcloud.api.antcloud.provider.AntCloudProviderRequest;
import cn.com.antcloud.api.provider.aks.v1_0_0.model.ContainerServiceDeployment;
import cn.com.antcloud.api.provider.aks.v1_0_0.response.CreateDeploymentResponse;
import java.lang.String;
import java.util.List;
import javax.validation.constraints.NotNull;

/**
 * 创建一个部署单，以对一组容器服务执行一次部署操作
 */
public class CreateDeploymentRequest extends AntCloudProviderRequest<CreateDeploymentResponse> {
  @NotNull
  private List<ContainerServiceDeployment> containerServices;

  @NotNull
  private String title;

  public CreateDeploymentRequest() {
    super("antcloud.aks.deployment.create", "1.0", "Java-SDK-20190814");
  }

  /**
   * 要部署的容器服务列表 */
  public List<ContainerServiceDeployment> getContainerServices() {
    return this.containerServices;
  }

  /**
   * 要部署的容器服务列表 */
  public void setContainerServices(List<ContainerServiceDeployment> containerServices) {
    this.containerServices = containerServices;
  }

  /**
   * 部署单标题。长度不超过50个UTF-8字符 */
  public String getTitle() {
    return this.title;
  }

  /**
   * 部署单标题。长度不超过50个UTF-8字符 */
  public void setTitle(String title) {
    this.title = title;
  }
}
