//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.aks.v1_0_0.request;

import cn.com.antcloud.api.antcloud.provider.AntCloudProviderRequest;
import cn.com.antcloud.api.provider.aks.v1_0_0.model.ContainerServiceConfig;
import cn.com.antcloud.api.provider.aks.v1_0_0.response.CreateContainerserviceResponse;
import java.lang.String;
import javax.validation.constraints.NotNull;

/**
 * 创建新的容器服务
 */
public class CreateContainerserviceRequest extends AntCloudProviderRequest<CreateContainerserviceResponse> {
  @NotNull
  private String appName;

  @NotNull
  private String cluster;

  @NotNull
  private ContainerServiceConfig config;

  @NotNull
  private String name;

  @NotNull
  private String namespace;

  @NotNull
  private String operator;

  @NotNull
  private String workspace;

  public CreateContainerserviceRequest() {
    super("antcloud.aks.containerservice.create", "1.0", "Java-SDK-20190814");
  }

  /**
   * 应用名 */
  public String getAppName() {
    return this.appName;
  }

  /**
   * 应用名 */
  public void setAppName(String appName) {
    this.appName = appName;
  }

  /**
   * 集群名 */
  public String getCluster() {
    return this.cluster;
  }

  /**
   * 集群名 */
  public void setCluster(String cluster) {
    this.cluster = cluster;
  }

  /**
   * 容器服务配置 */
  public ContainerServiceConfig getConfig() {
    return this.config;
  }

  /**
   * 容器服务配置 */
  public void setConfig(ContainerServiceConfig config) {
    this.config = config;
  }

  /**
   * 名称 */
  public String getName() {
    return this.name;
  }

  /**
   * 名称 */
  public void setName(String name) {
    this.name = name;
  }

  /**
   * 命名空间 */
  public String getNamespace() {
    return this.namespace;
  }

  /**
   * 命名空间 */
  public void setNamespace(String namespace) {
    this.namespace = namespace;
  }

  /**
   * 操作人 */
  public String getOperator() {
    return this.operator;
  }

  /**
   * 操作人 */
  public void setOperator(String operator) {
    this.operator = operator;
  }

  /**
   * 工作空间名 */
  public String getWorkspace() {
    return this.workspace;
  }

  /**
   * 工作空间名 */
  public void setWorkspace(String workspace) {
    this.workspace = workspace;
  }
}
